


-- TODO: auftgtxt
CREATE TABLE twawi.beleg_k__verkauf
 (
 ) INHERITS (TSystem_Wawi.beleg_k, TSystem_Wawi.beleg_k__preise_steu_zahlung);
--
CREATE TABLE twawi.beleg_p__verkauf
 (
  px_mengel_gme        NUMERIC(20,8),
  px_mengef_gme        NUMERIC(20,8),
  z_dokunr             INTEGER,
  --
  prv_pos_alternativ   VARCHAR(5),     -- Kennzeichen zur Steuerung
  ag_bem               TEXT,
  --
  ag_stkb              NUMERIC(20,8) NOT NULL DEFAULT 0,      -- Menge bestellt (eingekauft)
  
  ag_stkres            NUMERIC(12,4) NOT NULL DEFAULT 0,
  ag_stkres_uf1        NUMERIC(20,8),
  --
  ag_prkl              INTEGER, -- NOT NULL, -- ??TODO klären einkommentieren
  ag_kukl              INTEGER NOT NULL,
  --
  ag_parentabk         INTEGER,
  ag_ownabk            INTEGER,
  ag_mainabk           INTEGER,
  --
  ag_ang_ag_id         INTEGER,     -- angebots ag_id bei Angebot->Auftrag
  ag_kanf_nr           VARCHAR(20), -- REFERENCES kundanfrage,          -- wird in X_TableConstraints erstellt 
  ag_vtp_id            INTEGER,     -- REFERENCES in X_TableConstraints -- VertragsID     
  ag_nident            VARCHAR(50) REFERENCES qsnorm, -- Qualitätsnorm  
  ag_q_nr              INTEGER,                -- REFERENCES qab, -- wird in X_TableConstraints erstellt, enthält den QAB, für den dieser Auftrag ggf. als Nacharbeitsauftrag erstellt wurde
  --
  ag_rahmen_ag_id      INTEGER, -- TODO REFERENCES auftg ON UPDATE CASCADE,              -- verknüpfter Rahmen    
  ag_kanfwsk_wsk       VARCHAR(20), -- REFERENCES kanfwsk ON UPDATE CASCADE     -- #6679 Erweiterung Interessentenverwaltung, Referenz später, siehe  X_TableConstraints
  ag_absgrup           VARCHAR(20), --- REFERENCES kundabs ON UPDATE CASCADE -- #11689 Absage-Grund-Gruppe
  --
  prv_rust              NUMERIC(12,2),
  prv_fert              NUMERIC(12,2),
  prv_mat               NUMERIC(12,2),
  prv_awkost            NUMERIC(12,2),
  --
  prv_nk_stk            NUMERIC(14,6),
  prv_nk_stkl           NUMERIC(20,8),
  prv_nk_stkl_uf1       NUMERIC(20,8),
  prv_nk_w_wen          INTEGER,                                -- Wareneingangsnummer für Rohmaterial in Bearbeiten NK
  --
  prv_nk_vkp            NUMERIC(16,4),                     -- Preis in der Nachkalkulation: für Material, hierhinein schreibt auch Zubuchen der Eingangsrechnung. Der Kopfartikel-Gesamtpreis der Nachkalkulation steht in abk.ab_nk_et
  prv_nk_vkp_uf1        NUMERIC(20,8),
  prv_nk_calc_vkp       NUMERIC(16,4),                     -- kalkulierter Durchschnittspreis anhand realen Buchungen
  prv_nk_calc_vkp_uf1   NUMERIC(20,8)                      

 ) INHERITS (twawi.beleg_p, TSystem_Wawi.beleg_x__allgfields, TSystem_Wawi.beleg_p__extend__wawi__adk, TSystem_Wawi.beleg_p__extend__wawi__datum__bedarf, TSystem_Wawi.beleg_p__extend__zuschnitte);
-- Constraints und Trigger
 SELECT  TSystem_Wawi.beleg_p__trigger__all__create('twawi','beleg_p__verkauf');
 SELECT  TSystem_Wawi.beleg_p__constraints__all__create('twawi','beleg_p__verkauf', 'twawi','beleg_k');  
 
-- Adressen NOT NULL
 ALTER TABLE TWawi.beleg_p__verkauf ALTER COLUMN p_ad_krz SET NOT NULL;
 ALTER TABLE TWawi.beleg_p__verkauf ALTER COLUMN p_ad_krzl SET NOT NULL;
 ALTER TABLE TWawi.beleg_p__verkauf ALTER COLUMN p_ad_krzf SET NOT NULL; 
--
CREATE TABLE twawi.beleg_k__verkaufdoku(
   atd_fixwert           NUMERIC(16,4), 
   --
   atd_ld_auftg          VARCHAR(30),  -- TransportauftragsNr
   atd_bindefrist        VARCHAR(75),

   kvd_nachdat          	DATE,           --Datum des Nachtrags
   kvd_nachtitel         VARCHAR(200),	--Belegtitel Nachtrag
   kvd_nachtxt          	TEXT,           --Anschreiben Nachtrag
   kvd_nachtxt_rtf      	TEXT,
   kvd_nachtxt1         	TEXT,           --Schlusstext Nachtrag
   kvd_nachtxt1_rtf     	TEXT,

   kvd_empdat          	DATE,           --Datum der Empfangsbestätigung
   kvd_emptitel         	VARCHAR(200),	--Belegtitel Empfangsbestätigung
   kvd_emptxt          	TEXT,           --Anschreiben Empfangsbestätigung
   kvd_emptxt_rtf      	TEXT,
   kvd_emptxt1         	TEXT,           --Schlusstext Empfangsbestätigung
   kvd_emptxt1_rtf     	TEXT
 ) INHERITS (TSystem_Wawi.beleg_k, TSystem_Wawi.beleg_k__preise_steu_zahlung, TSystem_Wawi.beleg_x__allgfields);
-- Constraints und Trigger
 SELECT TSystem_Wawi.beleg_k__constraints__all__create ('twawi','beleg_k__verkaufdoku');
 SELECT TSystem_Wawi.beleg_k__trigger__wert__create('twawi','beleg_k__verkaufdoku');
-- TODO: CREATE UNIQUE INDEX?
--
-- TODO > Trigger ('#')
ALTER TABLE twawi.beleg_p__verkauf ALTER COLUMN p_ad_krzl DROP NOT NULL;
ALTER TABLE twawi.beleg_p__verkauf ALTER COLUMN p_ad_krzf DROP NOT NULL;
--
-- Trigger
 -- Dokumenten - Kopf anlegen, wenn Dokunr vergeben wird
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__verkaufdoku__a_500_iu__z_dokunr() RETURNS TRIGGER AS $$
  BEGIN  
   IF new.z_dokunr IS NOT NULL THEN   
       IF NOT EXISTS (SELECT true FROM twawi.beleg_k__verkaufdoku WHERE k_nummer = new.z_dokunr) THEN
          -- RAISE NOTICE '%, %, p_k_nummer = %, %', tg_relname, new.z_dokunr, new.p_k_nummer, new.ag_kukl;
          INSERT INTO twawi.beleg_k__verkaufdoku (k_nummer, k_waer, k_waer_kurs, k_ad_krz) VALUES (new.z_dokunr, new.p_waer, new.p_waer_kurs, new.p_ad_krz);
       END IF;
    ELSE -- z_dokunr IS NULL
      new.p_rabatt_gesamt := NULL; -- Ohne Dokument kein Gesamtrabatt in auftg
   END IF;
   -- FOLGENDES TODO : DELETE CASE > RAUS HIER
   IF tg_op = 'UPDATE' THEN --prüfen ob nach Umschreiben Dokunr noch Positionen vorhanden und ansonsten alten Kopf löschen
      IF old.z_dokunr IS NOT NULL THEN
         IF NOT EXISTS (SELECT true FROM twawi.beleg_p__verkauf WHERE p_k_nummer = old.z_dokunr) THEN
            DELETE FROM twawi.beleg_k__verkaufdoku WHERE k_nummer = old.z_dokunr;
         END IF;
      END IF;
   END IF;
   RETURN new;
  END $$ LANGUAGE plpgsql;
  
  CREATE TRIGGER a_50_iu__verkaufdoku__z_dokunr 
   AFTER INSERT OR UPDATE
   OF z_dokunr
   ON twawi.beleg_p__verkauf
   FOR EACH ROW
   EXECUTE PROCEDURE twawi.beleg_p__verkaufdoku__a_500_iu__z_dokunr();
 -- Gesamtrabatt Dokument an alle Positionen im Dokument bzw. alle Unterpositionen der Kopfpositionen im Dokument verteilen. Kopf MUSS immer auf Dokument sein, Position kann nie ohne Kopf auf Dokument sein
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__verkaufdoku__rabatt_propagate(knummer_dokunr VARCHAR) RETURNS BOOL AS $$
   BEGIN
     UPDATE TWawi.beleg_p__verkauf SET
            -- Grundfelder im eigentlichen Belkopf - Trigger, wird vom eigentlichen Auftragskopf vorgegeben
            
            p_rabatt_gesamt  = k_rabatt_gesamt,
            -- Werte in jedem Fall neu berechnen (k_rund_faktor gibts nicht in Pos)
            p_wert_netto     = NULL
      FROM  twawi.beleg_k__verkaufdoku
      WHERE  -- AND p_preis_sumsubpos; --Positionszeilen neu berechnen
            k_nummer = knummer_dokunr
            AND
            p_id IN
            (
             SELECT p_id FROM TWawi.beleg_p__verkauf WHERE z_dokunr = knummer_dokunr
            UNION 
             SELECT beleg_p__p_id__subpos_list FROM TWawi.beleg_p__verkauf JOIN LATERAL TSystem_Wawi.beleg_p__p_id__subpos_list(p_id, false) ON true WHERE z_dokunr = knummer_dokunr
            )
            AND
            p_rabatt_gesamt IS DISTINCT FROM k_rabatt_gesamt
            ;
    RETURN found; -- Wenn nichts gefunden wird
   END $$ LANGUAGE plpgsql STRICT;
   
 
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__verkaufdoku__a_310_u__wert__propagate() RETURNS TRIGGER AS $$
   BEGIN
     PERFORM TWawi.beleg_k__verkaufdoku__rabatt_propagate(new.k_nummer);
     --  
     RETURN new;
   END $$ LANGUAGE plpgsql;    
   
   CREATE TRIGGER a_310_u__verkaufdoku__wert__propagate
     AFTER UPDATE --im Insert gibt es noch keine Positionen die zu aktualisieren wären
     OF  
        k_rabatt_gesamt
     ON twawi.beleg_k__verkaufdoku
     FOR EACH ROW
     WHEN (new.k_rabatt_gesamt IS DISTINCT FROM old.k_rabatt_gesamt) 
     EXECUTE PROCEDURE TWawi.beleg_k__verkaufdoku__a_310_u__wert__propagate();   
 -- Bei Unterpositionen muß der Gesamtrabatt aus der Hauptposition gezogen werden; Bei allen normalen Positionen die normal im Dokument enthalten sind, wird der Gesamtrabatt über die Dokumentzugehörigkeit (z_dokunr) weitergegeben >>beleg_k__verkaufdoku__rabatt_propagate
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__verkauf__a_350_iu__rabatt_gesamt__from_doku_mainpos() RETURNS TRIGGER AS $$
  DECLARE dokunr VARCHAR;
          mainpid INTEGER;
  BEGIN
   SELECT DISTINCT z_dokunr INTO dokunr FROM twawi.beleg_p__verkauf WHERE p_id = TSystem_Wawi.beleg_p__p_id__mainpos(new.p_id, true, true); --Dokumentnummer der Hauptposition
   PERFORM TWawi.beleg_k__verkaufdoku__rabatt_propagate(dokunr);
   RETURN new;
  END $$ LANGUAGE plpgsql;
 
 CREATE TRIGGER a_350_iu__verkauf__rabatt_gesamt__from_doku_mainpos
   AFTER INSERT OR UPDATE
   OF p_parent_p_id, p_parent_pos
   ON twawi.beleg_p__verkauf
   FOR EACH ROW
   EXECUTE PROCEDURE twawi.beleg_p__verkauf__a_350_iu__rabatt_gesamt__from_doku_mainpos();
 -- Wenn Positionsbezug entfernt wird, muß auch Gesamtrabatt entsprechend umgesetzt werden
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__verkauf__b_310_iu__rabatt_gesamt__from_doku_mainpos() RETURNS TRIGGER AS $$
  BEGIN
   -- Pauschal NULL. Falls es doch Bezug zum Dokument gibt, wird dies über "beleg_p__verkauf__a_30_iu__rabatt_gesamt__from_doku_mainpos" wiederhergestellt
   -- Tritt auf, wenn Position aus Baumstruktur entfernt wird und damit indirekter Bezug zum Dokument über Hauptposition verloren geht.
   new.p_rabatt_gesamt := NULL;
   RETURN new;
  END $$ LANGUAGE plpgsql;
 -- 
 CREATE TRIGGER b_310_iu__verkauf__wert__possum__rabattgesamt --muß vor allgemeinem Trigger sein damit dort der richtige Gesamtrabatt verrechnet wird
  BEFORE UPDATE
  OF p_parent_p_id, p_parent_pos 
  ON TWawi.beleg_p__verkauf
  FOR EACH ROW
  EXECUTE PROCEDURE twawi.beleg_p__verkauf__b_310_iu__rabatt_gesamt__from_doku_mainpos();
 
  

-- VIEWS

-- TODO Update. CopyConstraintInfo
/*

CREATE VIEW z_99_deprecated.auftgdokutxt AS (
 SELECT
  k_nummer                              AS atd_dokunr,
  k_definitiv                           AS atd_defini,
                                        
  k_titel                               AS atd_titel,
                                        
  k_apext                               AS atd_ap,
  k_apext_ap_krzl                       AS atd_apkrzl,
  k_apint_db_usename1                   AS atd_apint,
  k_apint_db_usename2                   AS atd_apint2,
                                        
  k_rabatt_gesamt                       AS atd_gesrab,
                                        
  k_zak_zahlziel_d                      AS atd_zak,
  k_zak_skonto_verf_d                   AS atd_skv,
  k_zak_skonto_proz                     AS atd_sks,
  k_zak_bem                             AS atd_zakbem,
  
  k_versand_v_id                        AS atd_v_id,
  k_versand_bem                         AS atd_vers,
  k_versand_txt                         AS atd_versandbem, --TODO Feldübersetzung nochmal klären. Wirklich txt = bem?
  k_versand_txt_rtf                     AS atd_versandbem_rtf,
  k_versand_ort_adkrz                   AS atd_versandort,
     
  k_txt_anschr                          AS atd_txt,
  k_txt_anschr_rtf                      AS atd_txt_rtf,
  k_txt_schluss                         AS atd_txt1,
  k_txt_schluss_rtf                     AS atd_txt1_rtf,
                                        
  x_allgv1                              AS atd_allg1,
  x_allgv2                              AS atd_allg2,
  --
   atd_fixwert,  
   atd_ld_auftg,
   atd_bindefrist,

  kvd_nachdat                           AS atd_nachdat,
  kvd_nachtitel                         AS atd_nachtitel,
  kvd_nachtxt                           AS atd_nachtxt,
  kvd_nachtxt_rtf                       AS atd_nachtxt_rtf,
  kvd_nachtxt1                          AS atd_nachtxt1,
  kvd_nachtxt1_rtf                      AS atd_nachtxt1_rtf,
  kvd_empdat                            AS atd_empdat,
  kvd_emptitel                          AS atd_emptitel,
  kvd_emptxt                            AS atd_emptxt,
  kvd_emptxt_rtf                        AS atd_emptxt_rtf,
  kvd_emptxt1                           AS atd_emptxt1,
  kvd_emptxt1_rtf                       AS atd_emptxt1_rtf,    
  --
   dbrid,
   insert_date,
   insert_by,
   modified_by,
   modified_date
       
 FROM
  twawi.beleg_k__verkaufdoku
 );
--
CREATE VIEW z_99_deprecated.auftg AS (
 SELECT
  p_id                                  AS ag_id,
  p_k_code                              AS ag_astat,
  p_k_nummer                            AS ag_nr,
  p_pos                                 AS ag_pos,
  p_parent_pos                          AS ag_hpos, -- Übergeordnete Position (Hauptpos), diese Position ist deren Unterposition. Constraint="Position kann keine untergeordnete Position von sich selbst sein."  
  p_pos_strukturpos                     AS ag_hwpos,
  --                                    
  p_status_enum                         AS ag_stat,
  p_erfasst_datum                       AS ag_datum,
  --                                    
  p_done                                AS ag_done,
  p_storno                              AS ag_storno,
  p_storno_datum                        AS ag_stornodat,
  p_sperr                               AS ag_sperr,
  --                                    
  p_ad_krz                              AS ag_lkn,                          
  p_ad_krzl                             AS ag_krzl,
  p_ad_krzf                             AS ag_krzf, 
  --                                    
  p_txt                	                AS ag_txt,
  p_txt_rtf                             AS ag_txt_rtf, 
  p_txt_int                             AS ag_postxt,
  p_txt_int_rtf                         AS ag_postxt_rtf,
  --                                    
  p_aknr                                AS ag_aknr,
  p_ak_idx                              AS ag_aknr_idx,
  p_ak_bez                              AS ag_akbz,  
  --                                    
  p_menge                               AS ag_stk,
  p_menge_gme                           AS ag_stk_uf1,
  p_me                                  AS ag_mcv,
                                        
  px_mengel_gme                         AS ag_stkl,
  px_mengef_gme                         AS ag_stkf,
  --                                    
  p_preis_in_pe                         AS ag_preis,
  p_preis_pe                            AS ag_preiseinheit,
  p_preis                               AS ag_vkp,
  p_rabatt                              AS ag_arab,
  p_rabatt_hint                         AS ag_rabhint,
  p_rabatt_able                         AS ag_canRabatt,
  p_waer                                AS ag_waer,
  p_waer_kurs                           AS ag_kurs,
  --                                    
  p_preis_rabattiert                    AS ag_ep_netto,
  p_preis_gme                           AS ag_vkp_uf1,
  p_preis_gwaer                         AS ag_vkp_basis_w,
  p_preis_gme_gwaer                     AS ag_vkp_uf1_basis_w,
  p_preis_me                            AS ag_vkp_mce,
  p_preis_sumsubpos                     AS ag_vkptotalpos,
                                        
  p_nstatistik                          AS ag_nstatistik,
  --                                    
  p_steu_code                           AS ag_steucode,
  p_steu_proz                           AS ag_ustpr,  
  --                                    
  p_wert_tot_netto                      AS ag_netto,
  p_wert_tot_netto_gwaer                AS ag_netto_basis_w,
  p_wert_tot_brutto                     AS ag_brutto,
  p_wert_tot_brutto_gwaer               AS ag_brutto_basis_w,  
  --                                    
  p_aknr_referenz                       AS ag_aknr_referenz,
  p_adress_referenz_nummer              AS ag_bda, -- Bestellnummer d. Kunden
  p_adress_referenz_erstellt_datum      AS ag_bdat,
  p_adress_referenz_pos                 AS ag_bdapos,     -- Bestellposition d. Kunden
  --                                    
  p_ks                                  AS ag_ks,
  p_konto_erloes                        AS ag_konto,  
  --                                    
  px_an_nr                              AS ag_an_nr, 
  --                                    
  p_apext                               AS ag_dispo, 
  p_apext_ap_krzl                       AS ag_dispokrzl,
  p_apint_db_usename                    AS ag_kontakt,
  --                                    
  p_nbedarf                             AS ag_nbedarf,
  p_datuml_wunsch                       AS ag_kdatum,  
  p_datuml_bestaetigt                   AS ag_ldatum,
  p_datuml_verschoben                   AS ag_termv, 
  p_datuml_text                         AS ag_ldatumtext,
  p_datuml_auslieferterm                AS ag_aldatum,
  p_datuml_week                         AS ag_twa,
  --                                    
  x_allgv1                              AS ag_post1,
  x_allgv2                              AS ag_post2,
  x_allgv3                              AS ag_post3,
  x_allgv4                              AS ag_post4,
  x_allgv5                              AS ag_post5,
  x_allgv6                              AS ag_post6,
  x_allgv7                              AS ag_post7,
  --                                    
  zs_o6_dimi                            AS ag_o6_dimi,
  zs_o6_stkz                            AS ag_o6_stkz,
  zs_o6_lz                              AS ag_o6_lz,
  zs_o6_bz                              AS ag_o6_bz,
  zs_o6_hz                              AS ag_o6_hz,
  zs_o6_zz                              AS ag_o6_zz,
  zs_o6_zme                             AS ag_o6_zme,
  zs_o6_pos                             AS ag_o6_pos,
  --                                    
  z_dokunr                              AS ag_dokunr,
                                        
  prv_pos_alternativ                    AS ag_alt,
  ag_bem,                               
                                        
  p_bstat1                              AS ag_bstat,
  p_bstat2                              AS ag_bstat1,
  p_bstat3                              AS ag_bstat2,

  ag_stkb,

  ag_stkres,
  ag_stkres_uf1,

  ag_prkl,
  ag_kukl,

  ag_parentabk,
  ag_ownabk,
  ag_mainabk,
  
  ag_ang_ag_id,
  ag_kanf_nr,
  ag_vtp_id,
  ag_nident,
  ag_q_nr,

  ag_rahmen_ag_id,
  ag_kanfwsk_wsk,
  ag_absgrup,
  --
  p_ak_vkpbas                           AS ag_vkpbas,
  p_ak_hest                             AS ag_hest,
  --                                    
  prv_rust                              AS ag_rust,
  prv_fert                              AS ag_fert,
  prv_mat                               AS ag_mat,
  prv_awkost                            AS ag_awkost,
  --                                    
  prv_nk_stk                            AS ag_nk_stk,
  prv_nk_stkl                           AS ag_nk_stkl,
  prv_nk_stkl_uf1                       AS ag_nk_stkl_uf1,
  prv_nk_w_wen                          AS ag_nk_w_wen,
                                        
  prv_nk_vkp                            AS ag_nk_vkp,
  prv_nk_vkp_uf1                        AS ag_nk_vkp_uf1,
  prv_nk_calc_vkp                       AS ag_nk_calc_vkp,
  prv_nk_calc_vkp_uf1                   AS ag_nk_calc_vkp_uf1,
  --
  dbrid,
  insert_date,
  insert_by,
  modified_date,
  modified_by  
   
 FROM
  twawi.beleg_p__verkauf
 ); 
--
*/
